<?php
/* --------------------------------------------------------------
   ParcelServiceFactory.php 2020-02-10
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService;

use Gambio\Admin\ParcelService\Model\ParcelService;
use Gambio\Admin\ParcelService\Model\ParcelServiceDescription;
use Gambio\Admin\ParcelService\Model\ParcelServiceDescriptions;
use Gambio\Admin\ParcelService\Model\ParcelServiceId;
use Webmozart\Assert\Assert;

/**
 * Class ParcelServiceFactory
 *
 * @package Gambio\Admin\ParcelService
 */
class ParcelServiceFactory
{
    /**
     * @param array $descriptions
     *
     * @return ParcelServiceDescriptions
     */
    public function createParcelServiceDescriptions(array $descriptions): ParcelServiceDescriptions
    {
        Assert::allKeyExists($descriptions, 'languageId', 'All description items need a "languageId" key.');
        Assert::allKeyExists($descriptions, 'url', 'All description items need a "url" key.');
        Assert::allKeyExists($descriptions, 'comment', 'All description items need a "comment" key.');
        
        $collection = ParcelServiceDescriptions::create();
        foreach ($descriptions as $description) {
            $collection->add($description['languageId'],
                             ParcelServiceDescription::create($description['url'], $description['comment']));
        }
        
        return $collection;
    }
    
    
    /**
     * Creates a parcel service.
     *
     * @param int|null $id
     * @param string   $name
     * @param bool     $isDefault
     * @param array    $descriptions
     *
     * @return ParcelService
     */
    public function createParcelService(
        ?int $id,
        string $name,
        bool $isDefault,
        array $descriptions
    ): ParcelService {
        return ParcelService::create(ParcelServiceId::create($id),
                                     $name,
                                     $isDefault,
                                     $this->createParcelServiceDescriptions($descriptions));
    }
}
